#cox.r
#coxph models for survival; multivariate models with consideration of clinical hypothesis,
#univariate models, and backwards selection.

###overall survival
#univariate models for survival
library(survival)

agecox <- coxph(Surv(OS..M., Dead.)~age, data = oligo)
summary(agecox)
cox.zph(agecox)#test proportional hazards assumption

sitecox <- coxph(Surv(OS..M., Dead.)~site, data = oligo)
summary(sitecox)
cox.zph(sitecox)#test proportional hazards assumption

gendercox <- coxph(Surv(OS..M., Dead.)~Gender, data = oligo)
summary(gendercox)
cox.zph(gendercox)#test proportional hazards assumption

intervalcox <- coxph(Surv(OS..M., Dead.)~Dn..M1..M., data = oligo)
summary(intervalcox)
cox.zph(intervalcox)#test proportional hazards assumption

lesionscox <- coxph(Surv(OS..M., Dead.)~X..lesions.treated, data = oligo)
summary(lesionscox)
cox.zph(lesionscox)#test proportional hazards assumption

numorgcox <- coxph(Surv(OS..M., Dead.)~organs.initial, data = oligo)
summary(numorgcox)
cox.zph(numorgcox)#test proportional hazards assumption

metchemocox <- coxph(Surv(OS..M., Dead.)~M1.chem, data = oligo)
summary(metchemocox)
cox.zph(metchemocox)#test proportional hazards assumption

priorcurativecox <- coxph(Surv(OS..M., Dead.)~prior.curartive.local.tx, data = oligo)
summary(priorcurativecox)
cox.zph(priorcurativecox)#test proportional hazards assumption

lungcox <- coxph(Surv(OS..M., Dead.)~initial.lung, data = oligo)
summary(lungcox)
cox.zph(lungcox)#test proportional hazards assumption

hilarcox <- coxph(Surv(OS..M., Dead.)~initial.hilum..mediast, data = oligo)
summary(hilarcox)
cox.zph(hilarcox)#test proportional hazards assumption

livercox <- coxph(Surv(OS..M., Dead.)~initial.liver, data = oligo)
summary(livercox)
cox.zph(livercox)#test proportional hazards assumption

adrenalcox <- coxph(Surv(OS..M., Dead.)~initial.adrenal, data = oligo)
summary(adrenalcox)
cox.zph(adrenalcox)#test proportional hazards assumption

bonecox <- coxph(Surv(OS..M., Dead.)~initial.bone, data = oligo)
summary(bonecox)
cox.zph(bonecox)#test proportional hazards assumption

abdcox <- coxph(Surv(OS..M., Dead.)~abd.or.pelvic.LNs, data = oligo)
summary(abdcox)
cox.zph(abdcox)#test proportional hazards assumption

primchemocox <- coxph(Surv(OS..M., Dead.)~JH.primary.chemo, data = oligo)
summary(primchemocox)
cox.zph(primchemocox)#test proportional hazards assumption

#multivariate model
#model based on univariate and anything hypothesized
#for consideration, take a look at the backwards stepwise
library(MASS)
library(dplyr)
temp <- na.omit(select(oligo, OS..M., Dead., Dn..M1..M., site, X..lesions.treated, organs.initial, 
                         M1.chem, initial.hilum..mediast, initial.liver,
                         initial.adrenal, initial.bone, JH.primary.chemo))
start <- coxph(Surv(OS..M., Dead.)~ Dn..M1..M. + site + X..lesions.treated + organs.initial + 
                 M1.chem + initial.hilum..mediast + initial.liver+
                 initial.adrenal+ initial.bone+ JH.primary.chemo, data = temp)
backwards <- stepAIC(start,~., direction = "backward")

rm(temp, start, backwards)

#MV model with consideration of univariate, hypothesis, and backwards stepwise
mvcox <- coxph(Surv(OS..M., Dead.)~ Dn..M1..M. + site + X..lesions.treated +  
                 initial.hilum..mediast + initial.liver+
                 initial.adrenal+ initial.bone, data = oligo)
summary(mvcox)
cox.zph(mvcox)


library(dplyr)
temp <- filter(oligo, !is.na(Dn..M1..M.))
library(survminer)
ggcoxfunctional(Surv(OS..M., Dead.)~ Dn..M1..M., data = temp)

###BED analysis (not a pre-treatment factor)
bedcox <- coxph(Surv(OS..M., Dead.)~BED75up, data = oligo)
summary(bedcox)
cox.zph(bedcox)#test proportional hazards assumption

#multivariate plus BED
mvcox <- coxph(Surv(OS..M., Dead.)~ Dn..M1..M. + site + X..lesions.treated +  
                 initial.hilum..mediast + initial.liver+
                 initial.adrenal+ initial.bone + BED75up, data = oligo)
summary(mvcox)

#######PFS
#univariate models for PFS
require(survival)

agepfscox <- coxph(Surv(DFS.time, DFS)~age, data = oligo)
summary(agepfscox)
cox.zph(agepfscox)#test proportional hazards assumption

sitepfscox <- coxph(Surv(DFS.time, DFS)~site, data = oligo)
summary(sitepfscox)
cox.zph(sitepfscox)#test proportional hazards assumption

genderpfscox <- coxph(Surv(DFS.time, DFS)~Gender, data = oligo)
summary(genderpfscox)
cox.zph(genderpfscox)#test proportional hazards assumption

intervalpfscox <- coxph(Surv(DFS.time, DFS)~Dn..M1..M., data = oligo)
summary(intervalpfscox)
cox.zph(intervalpfscox)#test proportional hazards assumption

lesionspfscox <- coxph(Surv(DFS.time, DFS)~X..lesions.treated, data = oligo)
summary(lesionspfscox)
cox.zph(lesionspfscox)#test proportional hazards assumption

numorgpfscox <- coxph(Surv(DFS.time, DFS)~organs.initial, data = oligo)
summary(numorgpfscox)
cox.zph(numorgpfscox)#test proportional hazards assumption

metchemopfscox <- coxph(Surv(DFS.time, DFS)~M1.chem, data = oligo)
summary(metchemopfscox)
cox.zph(metchemopfscox)#test proportional hazards assumption

priorcurativepfscox <- coxph(Surv(DFS.time, DFS)~prior.curartive.local.tx, data = oligo)
summary(priorcurativepfscox)
cox.zph(priorcurativepfscox)#test proportional hazards assumption

lungpfscox <- coxph(Surv(DFS.time, DFS)~initial.lung, data = oligo)
summary(lungpfscox)
cox.zph(lungpfscox)#test proportional hazards assumption

hilarpfscox <- coxph(Surv(DFS.time, DFS)~initial.hilum..mediast, data = oligo)
summary(hilarpfscox)
cox.zph(hilarpfscox)#test proportional hazards assumption

liverpfscox <- coxph(Surv(DFS.time, DFS)~initial.liver, data = oligo)
summary(liverpfscox)
cox.zph(liverpfscox)#test proportional hazards assumption

adrenalpfscox <- coxph(Surv(DFS.time, DFS)~initial.adrenal, data = oligo)
summary(adrenalpfscox)
cox.zph(adrenalpfscox)#test proportional hazards assumption

bonepfscox <- coxph(Surv(DFS.time, DFS)~initial.bone, data = oligo)
summary(bonepfscox)
cox.zph(bonepfscox)#test proportional hazards assumption

abdpfscox <- coxph(Surv(DFS.time, DFS)~abd.or.pelvic.LNs, data = oligo)
summary(abdpfscox)
cox.zph(abdpfscox)#test proportional hazards assumption

primchemopfscox <- coxph(Surv(DFS.time, DFS)~JH.primary.chemo, data = oligo)
summary(primchemopfscox)
cox.zph(primchemopfscox)#test proportional hazards assumption

#multivariate model
#model based on univariate and anything hypothesized
#for consideration, take a look at the backwards stepwise
library(MASS)
library(dplyr)
temp <- na.omit(select(oligo, DFS.time, DFS, site, X..lesions.treated,  
                  organs.initial, Dn..M1..M., M1.chem, initial.hilum..mediast, 
                  initial.liver, initial.adrenal, initial.bone, JH.primary.chemo))


start <- coxph(Surv(DFS.time, DFS)~ site + X..lesions.treated +  + 
                 organs.initial + Dn..M1..M. + M1.chem + initial.hilum..mediast + 
                 initial.liver + initial.adrenal + initial.bone + JH.primary.chemo, data = temp)
backwards <- stepAIC(start,~., direction = "backward")

rm(temp, start, backwards)

#MV model with consideration of univariate, hypothesis, and backwards stepwise
mvpfscox <- coxph(Surv(DFS.time, DFS)~ site +  
                    organs.initial + 
                    initial.liver + JH.primary.chemo, 
                  data = oligo)
summary(mvpfscox)
cox.zph(mvpfscox)

###BED analysis (not a pre-treatment factor)
bedpfscox <- coxph(Surv(DFS.time, DFS)~BED75up, data = oligo)
summary(bedpfscox)
cox.zph(bedpfscox)#test proportional hazards assumption

#multivariate plus BED
mvpfscox <- coxph(Surv(DFS.time, DFS)~ site +  
                    organs.initial + 
                    initial.liver + JH.primary.chemo + BED75up, 
                  data = oligo)
summary(mvpfscox)

##################################
#TMC
require(survival)

sitetmccox <- coxph(Surv(LF.time.p.RT, LF)~site, data = oligo)
summary(sitetmccox)
cox.zph(sitetmccox)#test proportional hazards assumption

intervaltmccox <- coxph(Surv(LF.time.p.RT, LF)~Dn..M1..M., data = oligo)
summary(intervaltmccox)
cox.zph(intervaltmccox)#test proportional hazards assumption

lesionstmccox <- coxph(Surv(LF.time.p.RT, LF)~X..lesions.treated, data = oligo)
summary(lesionstmccox)
cox.zph(lesionstmccox)#test proportional hazards assumption

numorgtmccox <- coxph(Surv(LF.time.p.RT, LF)~organs.initial, data = oligo)
summary(numorgtmccox)
cox.zph(numorgtmccox)#test proportional hazards assumption

metchemotmccox <- coxph(Surv(LF.time.p.RT, LF)~M1.chem, data = oligo)
summary(metchemotmccox)
cox.zph(metchemotmccox)#test proportional hazards assumption

priorcurativetmccox <- coxph(Surv(LF.time.p.RT, LF)~prior.curartive.local.tx, data = oligo)
summary(priorcurativetmccox)
cox.zph(priorcurativetmccox)#test proportional hazards assumption

lungtmccox <- coxph(Surv(LF.time.p.RT, LF)~initial.lung, data = oligo)
summary(lungtmccox)
cox.zph(lungtmccox)#test proportional hazards assumption

hilartmccox <- coxph(Surv(LF.time.p.RT, LF)~initial.hilum..mediast, data = oligo)
summary(hilartmccox)
cox.zph(hilartmccox)#test proportional hazards assumption

livertmccox <- coxph(Surv(LF.time.p.RT, LF)~initial.liver, data = oligo)
summary(livertmccox)
cox.zph(livertmccox)#test proportional hazards assumption

adrenaltmccox <- coxph(Surv(LF.time.p.RT, LF)~initial.adrenal, data = oligo)
summary(adrenaltmccox)
cox.zph(adrenaltmccox)#test proportional hazards assumption

bonetmccox <- coxph(Surv(LF.time.p.RT, LF)~initial.bone, data = oligo)
summary(bonetmccox)
cox.zph(bonetmccox)#test proportional hazards assumption

abdtmccox <- coxph(Surv(LF.time.p.RT, LF)~abd.or.pelvic.LNs, data = oligo)
summary(abdtmccox)
cox.zph(abdtmccox)#test proportional hazards assumption

primchemotmccox <- coxph(Surv(LF.time.p.RT, LF)~JH.primary.chemo, data = oligo)
summary(primchemotmccox)
cox.zph(primchemotmccox)#test proportional hazards assumption


#multivariate model
#model based on univariate and anything hypothesized
#for consideration, take a look at the backwards stepwise
library(MASS)
library(dplyr)
temp <- na.omit(select(oligo, LF.time.p.RT, LF, site, X..lesions.treated, organs.initial, 
                  M1.chem, prior.curartive.local.tx, 
                  initial.hilum..mediast, initial.liver,
                  initial.bone, JH.primary.chemo))


start <- coxph(Surv(LF.time.p.RT, LF)~ site + X..lesions.treated + organs.initial + 
                 M1.chem + prior.curartive.local.tx+ 
                 initial.hilum..mediast + initial.liver+
                 initial.bone+ JH.primary.chemo, data = temp)
backwards <- stepAIC(start,~., direction = "backward")

rm(temp, start, backwards)

#MV model with consideration of univariate, hypothesis, and backwards stepwise
mvtmccox <- coxph(Surv(LF.time.p.RT, LF)~ site +  
                    M1.chem + prior.curartive.local.tx+ 
                    initial.hilum..mediast + initial.liver,
                  data = oligo)
summary(mvtmccox)
cox.zph(mvtmccox)


###BED analysis (not a pre-treatment factor)
bedtmccox <- coxph(Surv(LF.time.p.RT, LF)~BED75up, data = oligo)
summary(bedtmccox)
cox.zph(bedtmccox)#test proportional hazards assumption

#multivariate plus BED
mvtmccox <- coxph(Surv(LF.time.p.RT, LF)~ site +  
                    M1.chem + prior.curartive.local.tx+ 
                    initial.hilum..mediast + initial.liver+ BED75up,
                  data = oligo)
summary(mvtmccox)
