% Dprofile_demo_SH_JJA_archive

% 1) LOAD PRIMARY DATA
ws_dir = '';
aqua_ws = load([ws_dir 'tiffany_ECHAM16K_Dmax_attrib_jul10_2018.mat']);
amip_ws = load([ws_dir 'tiffany_AMIP16K_Dmax_attrib_jul09_2018.mat']);
max_lv_aqua = aqua_ws.max_lats_vals(1:2,:,:); %(actual + linear) x 9 exps x (shift + change)
max_lv_amip = amip_ws.max_lats_vals(1:2,:,:); %(actual + linear) x 9 exps x (shift + change)
max_lv_amip(:,:,1) = -max_lv_amip(:,:,1); %Switch units to deg S
Deddy_actual_aqua = aqua_ws.Deddy_actual; %1801 lats x 9 exps
Deddy_linear_aqua = bsxfun(@plus,Deddy_actual_aqua(:,5),aqua_ws.dD_linear);
Deddy_actual_amip = amip_ws.Deddy_actual;
Deddy_linear_amip = bsxfun(@plus,Deddy_actual_amip(:,5),amip_ws.dD_linear);
d_sst = amip_ws.d_sst;
lat   = amip_ws.lat_hi;
Deddy_aqua = cat(3,Deddy_actual_aqua,Deddy_linear_aqua); %96 lats x 9 exps x (actual + linear)
Deddy_amip = cat(3,Deddy_actual_amip,Deddy_linear_amip); %96 lats x 9 exps x (actual + linear)
Deddy_amip = flip(Deddy_amip,1); %Latitudes now deg S
Deddy_plot = cat(4,Deddy_aqua,Deddy_amip); %96 lats x 9 exps x (actual + linear) x (AQUA + AMIP)
max_lv     = cat(4,max_lv_aqua,max_lv_amip); %(actual + linear) x 9 exps x
    %(shift + change) x (AQUA + AMIP)
max_lv     = permute(max_lv,[2 3 1 4]);%9 exps x (shift + change) x (actual
    %+ linear) x (AQUA + AMIP)
    
% 3) SET FIGURE PARAMETERS
% a) Horizontal half page w/ legends at right, 19.0 cm wide x 11.5 cm tall
fwidth   = 19; %Figure width
fheight  = 11.5; %Figure height
bmargin  = .9; %Bottom margin
hmargin  = .3; %Horizontal margin (between rows)
tmargin  = .25; %Top margin
lmargin  = 1; %Left margin
vmargin  = .3; %Vertical margin (between columns)
rmargin  = .25;%Right margin
pheight  = 0.5*(fheight-bmargin-hmargin-tmargin); %Panel height
pwidth   = 0.5*(fwidth-lmargin-vmargin-rmargin);%Panel width

% 4) SET AXES PARAMETERS
fontsize = 8; %Requested by AGU
ylims    = [0 20];
yticks   = 0:2:20;
panel_labs = {'(a)','(b)';'(c)','(d)'}; %One per panel
panel_yval = 17;
panel_xval = 23;
cmap = parula(9);
               
% 5) CHECK IF FIGURES EXIST
%sname = mfilename;
%sname = sname(22:end); %Get version number
%plot_dir = '/project/tas1/tmooring/plots/echam_diffusivity_plots/';
%if exist([plot_dir 'Dprofile_demo_SH_JJA_'  sname '.ps'],'file')
%    error('Planned output plot already exists!')
%end

% 6) DRAW THE FIGURES
axpos_basic = {[lmargin     bmargin+pheight+hmargin pwidth pheight],...
    [lmargin+pwidth+vmargin bmargin+pheight+hmargin pwidth pheight]};
axpos_mmc   = {[lmargin     bmargin                 pwidth pheight],...
    [lmargin+pwidth+vmargin bmargin                 pwidth pheight]};
axpos       = [axpos_basic; axpos_mmc];
lhpos       = [7 6.5 2 2.7];
%ctrlnames   = {'AQUA','AMIP'};
xlabs       = {'Latitude (deg)','Latitude (deg S)'};
ylabs       = {'Actual diffusivity (Tg/s)','Linearly-estimated diffusivity (Tg/s)'};
%ylunits     = {'(deg poleward)','(Tg/s)'}; %1 Tg = 10^9 kg
% a) Create figure
fh = figure('units','centimeters','position',[3 3 fwidth fheight],...
    'paperunits','centimeters','papersize',[fwidth fheight],...
    'paperposition',[0 0 fwidth fheight],'color','w');
axarr = NaN(2,2); %Axes IDs for current figure
% b) Draw basic decomposition
for kk = 1:2
    %AQUA + SH JJA
for jj = 1:2
    %actual + linear

axarr(jj,kk) = axes('units','centimeters','position',axpos{jj,kk});

for ii = 1:9
    %simulations (lines)
plot(axarr(jj,kk),lat,Deddy_plot(:,ii,jj,kk)/1e9,'color',cmap(ii,:));
hold on
end
for ii = 1:9
    %simulations (markers)
plot(axarr(jj,kk),max_lv(ii,1,jj,kk),max_lv(ii,2,jj,kk)/1e9,'color',...
    cmap(ii,:),'marker','o','markerfacecolor',cmap(ii,:));
hold on
end
set(axarr(jj,kk),'position',axpos{jj,kk},'xlim',[20 60],'xtick',20:5:60,...
    'fontsize',fontsize,'ylim',ylims,'ytick',yticks,'layer','top') %,'xgrid','on','ygrid',...
    %'on','layer','top')
if kk==1
ylabel(ylabs{jj},'fontsize',fontsize)
set(axarr(jj,kk),'xtick',20:5:55)
elseif kk==2
set(axarr(jj,kk),'yticklabels',[]) %No y labels on right column
end
if jj==1
set(axarr(jj,kk),'xticklabels',[])
elseif jj==2
xlabel(xlabs{kk},'fontsize',fontsize)
end
if isequal(jj,kk,1)
lh = legend('-8K','-6K','-4K','-2K','Control','+2K','+4K','+6K','+8K',...
    'location','southeast');
legend boxoff
set(lh,'units','centimeters','position',lhpos)
end
text(panel_xval,panel_yval,panel_labs{jj,kk},'fontsize',fontsize)
end %actual + linear
end %ensemble

% d) Save figure
pause(1)
set(fh,'position',[3 3 fwidth fheight])
pause(1)
for kk = 1:2
for jj = 1:2
set(axarr(jj,kk),'position',axpos{jj,kk})
pause(1)
end
end
set(gcf,'position',[3 3 fwidth fheight])
pause(1)
print(fh,'-dpsc','Dprofile_demo_SH_JJA_archive.ps'); %On draft copies of these
    %figures PageBoundingBox has value 0 0 539 326.  This corresponds to a
    %figure 19.0147 cm wide and 11.5006 cm high, as desired.
pause(1)
close(fh)
