% D_effect_in_EBM_v6_archive

% 1) LOAD DATA
load EBM_AQUA_Dtot_sensitivity_may23_2019.mat
lath = (-89.9:.1:89.9)'; %Mistakenly forgot to store in this workspace

% 2) SET FIGURE PARAMETERS
%    Horizontal half page, 19.0 cm wide x 11.5 cm tall
fwidth   = 19; %Figure width
fheight  = 11.5; %Figure height
bmargin  = .9; %Bottom margin
hmargin  = .3; %Horizontal margin (between rows)
tmargin  = .25; %Top margin
lmargin  = 1.2; %Left margin
vmargin  = 1.4; %Vertical margin (between columns)
rmargin  = .25;%Right margin
pheight  = 0.5*(fheight-bmargin-hmargin-tmargin); %Panel height
pwidth   = 0.5*(fwidth-lmargin-vmargin-rmargin);%Panel width

% 3) SET AXES PARAMETERS
fontsize = 8; %Requested by AGU
xlims = [0 90];
ylims = {[260 310],[-6 9];[-2 10],[-1.5 1.5]};
xticks = 0:15:90;
yticks = {260:10:310,-6:3:9;-2:2:10,-1.5:.5:1.5};
panel_labs = {'(a)','(b)';'(c)','(d)'}; %One per panel
panel_xval = 13;
panel_yval = [305 .9*15-6; .9*12-2 .9*3-1.5];
yldesc    = {'925 hPa T (K)','925 hPa T anomaly (K)';...
   'Total MSE transport (PW)','Total MSE transport anomaly (PW)'};
l_pos = {[3.5 10 4 1]   ,[13.5 8.5 4 1];...
         [3.5 4.5 4 .67],[12.5 4.5 4 .67]};
               
% 4) CHECK IF FIGURE EXISTS
%sname = mfilename;
%sname = sname(17:end); %Get version number
%plot_dir = '/project/tas1/tmooring/plots/echam_diffusivity_plots/';
%if exist([plot_dir 'D_effect_in_EBM_'  sname '.ps'],'file')
%    error('Planned output plot already exists!')
%end

% 5) DRAW FIGURE
axpos_all = {[lmargin     bmargin+pheight+hmargin pwidth pheight],...
  [lmargin+pwidth+vmargin bmargin+pheight+hmargin pwidth pheight];...
             [lmargin     bmargin                 pwidth pheight],...
  [lmargin+pwidth+vmargin bmargin                 pwidth pheight]};
axarr = NaN(2,2);
fh = figure('units','centimeters','position',[3 3 fwidth fheight],...
    'paperunits','centimeters','papersize',[fwidth fheight],...
    'paperposition',[0 0 fwidth fheight],'color','w');
% a) 925 hPa T
axarr(1,1) = axes('units','centimeters','position',axpos_all{1,1});

plot([-10 -5],[0 0],'color',cblind8('blu'),'linestyle','--');
hold on
plot([-10 -5],[0 0],'color',cblind8('blu'));
plot([-10 -5],[0 0],'color',cblind8('bgr'));
plot([-10 -5],[0 0],'color',cblind8('bla'),'linestyle','--');
plot([-10 -5],[0 0],'color',cblind8('bla'));

plot(latf,Tr(:,2)   ,'color',cblind8('blu'),'linestyle','--');
plot(latf,Tdfix(:,2),'color',cblind8('blu'));
plot(latf,TchDo(:,2),'color',cblind8('bgr'));
plot(latf,Tr(:,3)   ,'color',cblind8('bla'),'linestyle','--');
plot(latf,Tdfix(:,3),'color',cblind8('bla'));
plot(latf,Tr(:,4)   ,'color',cblind8('ver'),'linestyle','--');
plot(latf,Tdfix(:,4),'color',cblind8('ver'));
plot(latf,TchDo(:,4),'color',cblind8('ora'));
ylabel(yldesc{1,1},'fontsize',fontsize,'position',[-8 285])
lh_11 = legend('-4K GCM',...
       '-4K EBM, change all but Dtot',...
       '-4K EBM, change only Dtot',...
       'Control GCM',...
       'Control EBM','location','southwest');
legend boxoff
set(lh_11,'units','centimeters','position',[4 9.2 5 2])
text(panel_xval,panel_yval(1,1),panel_labs{1,1},'fontsize',fontsize)
set(axarr(1,1),'position',axpos_all{1,1},'xlim',xlims,'xtick',...
    xticks,'fontsize',fontsize,'ylim',ylims{1,1},'ytick',yticks{1,1},...
    'xticklabel',[])
% b) 925 hPa T anomaly
axarr(1,2) = axes('units','centimeters','position',axpos_all{1,1});

plot([-10 -5],[0 0],'color',cblind8('ver'),'linestyle','--');
hold on
plot([-10 -5],[0 0],'color',cblind8('ver'));
plot([-10 -5],[0 0],'color',cblind8('ora'));

plot(latf,Tr(:,2)-Tr(:,3)      ,'color',cblind8('blu'),'linestyle','--');
plot(latf,Tdfix(:,2)-Tdfix(:,3),'color',cblind8('blu'));
plot(latf,TchDo(:,2)-TchDo(:,3),'color',cblind8('bgr'));
plot([0 90],[0 0],              'color',cblind8('bla'));
plot(latf,Tr(:,4)-Tr(:,3)      ,'color',cblind8('ver'),'linestyle','--');
plot(latf,Tdfix(:,4)-Tdfix(:,3),'color',cblind8('ver'));
plot(latf,TchDo(:,4)-TchDo(:,3),'color',cblind8('ora'));
ylabel(yldesc{1,2},'fontsize',fontsize,'position',[-9 1.5])
lh_12 = legend('+4K GCM',...
       '+4K EBM, change all but Dtot',...
       '+4K EBM, change only Dtot',...
       'location','southwest');
legend boxoff
set(lh_12,'units','centimeters','position',[10.8 8.4 5 1.1])
text(panel_xval,panel_yval(1,2),panel_labs{1,2},'fontsize',fontsize)
set(axarr(1,2),'position',axpos_all{1,2},'xlim',xlims,'xtick',...
    xticks,'fontsize',fontsize,'ylim',ylims{1,2},'ytick',yticks{1,2},...
    'xticklabel',[])
% c) Eddy MSE transport
axarr(2,1) = axes('units','centimeters','position',axpos_all{2,1});
plot(lath,Hr(:,1,2)/1e15 ,'color',cblind8('blu'),'linestyle','--');
hold on
plot(lath,Hdfix(:,2)/1e15,'color',cblind8('blu'));
plot(lath,HchDo(:,2)/1e15,'color',cblind8('bgr'));
plot(lath,Hr(:,1,3)/1e15 ,'color',cblind8('bla'),'linestyle','--');
plot(lath,Hdfix(:,3)/1e15,'color',cblind8('bla'));
plot(lath,Hr(:,1,4)/1e15 ,'color',cblind8('ver'),'linestyle','--');
plot(lath,Hdfix(:,4)/1e15,'color',cblind8('ver'));
plot(lath,HchDo(:,4)/1e15,'color',cblind8('ora'));
ylabel(yldesc{2,1},'fontsize',fontsize,'position',[-8 4])
xlabel('Latitude (deg)','fontsize',fontsize)
text(panel_xval,panel_yval(2,1),panel_labs{2,1},'fontsize',fontsize)
set(axarr(2,1),'position',axpos_all{2,1},'xlim',xlims,'xtick',...
    xticks,'fontsize',fontsize,'ylim',ylims{2,1},'ytick',yticks{2,1})
% d) Eddy MSE transport anomaly
axarr(2,2) = axes('units','centimeters','position',axpos_all{2,2});
plot(lath,(Hr(:,1,2)-Hr(:,1,3))/1e15 ,'color',cblind8('blu'),'linestyle','--');
hold on
plot(lath,(Hdfix(:,2)-Hdfix(:,3))/1e15,'color',cblind8('blu'));
plot(lath,(HchDo(:,2)-HchDo(:,3))/1e15,'color',cblind8('bgr'));
plot([0 90],[0 0],'color',cblind8('bla'));
plot(lath,(Hr(:,1,4)-Hr(:,1,3))/1e15 ,'color',cblind8('ver'),'linestyle','--');
plot(lath,(Hdfix(:,4)-Hdfix(:,3))/1e15,'color',cblind8('ver'));
plot(lath,(HchDo(:,4)-HchDo(:,3))/1e15,'color',cblind8('ora'));
ylabel(yldesc{2,2},'fontsize',fontsize,'position',[-9 0])
xlabel('Latitude (deg)','fontsize',fontsize)
text(panel_xval,panel_yval(2,2),panel_labs{2,2},'fontsize',fontsize)
set(axarr(2,2),'position',axpos_all{2,2},'xlim',xlims,'xtick',...
    xticks,'fontsize',fontsize,'ylim',ylims{2,2},'ytick',yticks{2,2})
% e) Save figure
pause(1)
set(fh,'position',[3 3 fwidth fheight])
pause(1)
for ii = 1:2
    %T, H
for jj = 1:2
    %full, anom
set(axarr(ii,jj),'position',axpos_all{ii,jj})
pause(1)
end
end
set(gcf,'position',[3 3 fwidth fheight])
pause(1)
print(fh,'-dpsc','D_effect_in_EBM_v6_archive.ps'); %On draft copies of these
    %figures PageBoundingBox has value 0 0 539 326.  This corresponds to a
    %figure 19.0147 cm wide and 11.5006 cm high, as desired.
pause(1)
close(fh)