function cvec = cblind8(cname)

% This function returns colors from an 8-color (including black) palette
% optimized for readability by color-blind people and presented in Wong
% 2011 (doi:10.1038/nmeth.1618).
%
% INPUT
% cname    Name of color desired--one of 8, including black.  Not giving an
%              input argument, passing the empty matrix, or passing 'all' 
%              will return all 8 colors in an array.  Passing 'noblack'
%              will return the 7 non-black colors in a single array.
%
% OUTPUT
% cvec     A three-element row vector or three-column matrix of RGB values
%              defining colors

cvec = [  0   0   0; 230 159 0;  86 180 233;   0 158 115; 240 228 66; ...
          0 114 178; 213  94 0; 204 121 167]/255;
      
if (~exist('cname','var')) || isempty(cname) || strcmpi(cname,'all')
    return
elseif strcmpi(cname(1:3),'nob') %No black array
    cvec = cvec(2:end,:);
elseif strcmpi(cname(1:3),'bla') %black
    cvec = cvec(1,:);
elseif strcmpi(cname(1:3),'ora') %orange
    cvec = cvec(2,:);
elseif strcmpi(cname(1:3),'sbl') %sky blue
    cvec = cvec(3,:);
elseif strcmpi(cname(1:3),'bgr') %bluish green
    cvec = cvec(4,:);
elseif strcmpi(cname(1:3),'yel') %yellow
    cvec = cvec(5,:);
elseif strcmpi(cname(1:3),'blu') %blue
    cvec = cvec(6,:);
elseif strcmpi(cname(1:3),'ver') %vermillion
    cvec = cvec(7,:);
elseif strcmpi(cname(1:3),'rpu') %reddish purple
    cvec = cvec(8,:);
else
    error([cname ' is not a valid color!'])
end    