% Tgrad_DSELE_SH_JJA_archive

% 1) LOAD PRIMARY DATA
ws_dir = '';
% a) T gradient shift decomposition
dmax_g = NaN(5,9,2); %(actual, linear, true grad, fxRH grad, fxRT grad) x 9
    %exps x (AQUA + SH JJA)
aqua_ws = load([ws_dir 'tiffany_ECHAM16K_G_investigation_nov23_2019.mat']);
amip_ws = load([ws_dir 'tiffany_AMIP16K_G_investigation_nov23_2019.mat']);
dmax_g([1 3:5],:,1) = aqua_ws.dmax_lats_vals([1 2 4 5],:,1); %Need to get total
dmax_g([1 3:5],:,2) = amip_ws.dmax_lats_vals([1 2 4 5],:,1); %linear shift elsewhere
d_sst               = amip_ws.d_sst;

% b) DSE/LE gradient decomposition
dmax_dl = NaN(6,9,2);%(actual, linear, full grad, DSE grad, LE grad, DSE/LE
    %interaction) x 9 exps x (AQUA + SH JJA)
aqua_ws_dl = load([ws_dir 'tiffany_ECHAM16K_Dmax_attrib_jul10_2018b.mat']);
amip_ws_dl = load([ws_dir 'tiffany_AMIP16K_Dmax_attrib_jul10_2018b.mat']);
dmax_dl(:,:,1) = aqua_ws_dl.dmax_lats_vals([1 2 6 8:10],:,1);
dmax_dl(:,:,2) = amip_ws_dl.dmax_lats_vals([1 2 6 8:10],:,1);
dmax_dl(4:5,:,:) = dmax_dl([5 4],:,:);%(actual, linear, full grad, LE grad,
    %DSE grad, DSE/LE interaction) x 9 exps x (AQUA + SH JJA)
dmax_dl          = dmax_dl([1 3:6],:,:); %Drop total linear

% c) Complete T gradient shift decomposition
%    Note that the total linear line of the T gradient shift panels is
%    coming from a different set of attribution analyses than the other
%    lines.
%NO ACTUALLY WE DON'T NEED TO DO THIS!
% dmax_g(2,:,1) = aqua_ws_dl.dmax_lats_vals(2,:,1);
% dmax_g(2,:,2) = amip_ws_dl.dmax_lats_vals(2,:,1);
%dmax_g(2,:,1) = aqua_ws_dl.dmax_lats_values(2,2:10,1);
%dmax_g(2,:,2) = amip_ws_dl.dmax_lats_values(2,:,1);
dmax_g = dmax_g([1 3:5],:,:);%(actual, true grad, fxRH grad, fxRT grad) x 9
    %exps x (AQUA + SH JJA)--dropping total linear
%dmax_g(3,1,2) = NaN; %Drop huge shift point at -8K

% 2) LOAD INTERNAL VARIABILITY DATA
%    Adapted from basic_mmc_SH_JJA_v3
aqua_iav = load([ws_dir 'tiffany_ECHAM16K_Dmax_attrib_jul12_2018.mat']);
amip_iav = load([ws_dir 'tiffany_AMIP16K_Dmax_attrib_jul12_2018.mat']);

aqua_mlv = squeeze(aqua_iav.max_lats_vals(:,:,1,1));%4 seasons x 9 years
    %x max lats.  This is for Qobs with the diffusivity
    %defined using transient eddy transport.
aqua_mlv = reshape(aqua_mlv,[36 1]); %36 seasons x max lats
aqua_mlv = std(aqua_mlv,1,1); %Standard deviation across months,
    %normalize by N because data are complete

amip_mlv = squeeze(amip_iav.max_lats_vals(:,1,1));
    %Select 30 years x transient-eddy based x max lats
amip_mlv = std(amip_mlv,1,1); %Standard deviation across years,
    %normalize by N because data are complete
    
all_mlv = [aqua_mlv amip_mlv]; %Combine for plotting

% 3) SET FIGURE PARAMETERS
% a) Horizontal half page w/ legends at right, 19.0 cm wide x 11.5 cm tall
fwidth   = 19; %Figure width
fheight  = 11.5; %Figure height
bmargin  = .9; %Bottom margin
hmargin  = .3; %Horizontal margin (between rows)
tmargin  = .25; %Top margin
lmargin  = 1; %Left margin
vmargin  = .3; %Vertical margin (between columns)
rmargin  = .25;%Right margin
pheight  = 0.5*(fheight-bmargin-hmargin-tmargin); %Panel height
pwidth   = 0.5*(fwidth-lmargin-vmargin-rmargin);%Panel width

% 4) SET AXES PARAMETERS
fontsize = 8; %Requested by AGU
tgrad_style = {cblind8('ver'),cblind8('ver'),'-';...  %Actual
               cblind8('ora'),cblind8('ora'),'-';...  %Gradient (true)
               cblind8('ora'),cblind8('ora'),'--';... %Gradient (fxRH)
               cblind8('ora'),'none'        ,'-.'};   %Gradient (fxRT)
    %Styles for T gradient analysis lines--first column is color, second
    %column is marker face color, third column is line style.
dsele_style = {cblind8('ver'),cblind8('ver'),'-';...  %Actual
               cblind8('ora'),cblind8('ora'),'-';...  %Gradient (MSE)
               cblind8('sbl'),cblind8('sbl'),'-';...  %Gradient (LE)
               cblind8('sbl'),cblind8('sbl'),'--';... %Gradient (DSE)
               cblind8('bla'),'none'        ,':'};    %DSE/LE interaction
ylims  = [-6 10]; %shift
yticks = -6:2:10;
panel_labs = {'(a)','(b)';'(c)','(d)'}; %One per panel
panel_yval = 8; %shift
panel_xval = -8;
               
% 5) CHECK IF FIGURE EXISTS
% sname = mfilename;
% sname = sname(20:end); %Get version number
% plot_dir = '/project/tas1/tmooring/plots/echam_diffusivity_plots/';
% if exist([plot_dir 'Tgrad_DSELE_SH_JJA_'  sname '.ps'],'file')
%     error('Planned output plot already exists!')
% end

% 6) DRAW THE FIGURES
axpos_dsele = {[lmargin     bmargin+pheight+hmargin pwidth pheight],...
    [lmargin+pwidth+vmargin bmargin+pheight+hmargin pwidth pheight]};
axpos_tgrad = {[lmargin     bmargin                 pwidth pheight],...
    [lmargin+pwidth+vmargin bmargin                 pwidth pheight]};
ctrlnames   = {'AQUA','AMIP'};
l_dsele_pos = [11.5 9.25 5 1.5];
l_tgrad_pos = [11.75 4 5 1.75];

% a) Create figure
fh = figure('units','centimeters','position',[3 3 fwidth fheight],...
    'paperunits','centimeters','papersize',[fwidth fheight],...
    'paperposition',[0 0 fwidth fheight],'color','w');
axarr = NaN(2,2); %Axes IDs for current figure

% b) Draw T gradient decomposition
for jj = 1:2
    %AQUA + SH JJA

axarr(1,jj) = axes('units','centimeters','position',axpos_tgrad{jj});

for ii = 1:size(tgrad_style,1)
    %terms--for legend
plot(axarr(1,jj),-10,0,'marker','o','color',tgrad_style{ii,1},...
    'markerfacecolor',tgrad_style{ii,2},'linestyle',tgrad_style{ii,3},...
    'markersize',4,'linewidth',1);
hold on
end %terms--for legend
patch([-10 10 10 -10],all_mlv(1,jj)*[-1 -1 1 1],[.9 .9 .9],...
    'linestyle','none')
plot([-9 9],[0 0],'k-','linewidth',0.5)

for ii = 1:size(tgrad_style,1)
    %terms--actual data
plot(d_sst,dmax_g(ii,:,jj),'marker','o','color',tgrad_style{ii,1},...
    'markerfacecolor',tgrad_style{ii,2},'linestyle',tgrad_style{ii,3},...
    'linewidth',1,'markersize',4);
end %terms--actual data

set(axarr(1,jj),'position',axpos_tgrad{jj},'xlim',[-9 9],'xtick',d_sst,...
    'fontsize',fontsize,'ylim',ylims,'ytick',yticks,...
    'layer','top')
if jj==1
ylabel('Shift of D maximum (deg poleward)','fontsize',fontsize)
elseif jj==2
set(axarr(1,jj),'yticklabels',[]) %No y labels on right column
end
if jj==2 %(kk==1) && (jj==2)
    %Add the basic legend to the SH JUL shift panel
lh_tgrad = legend('\deltaD_{} Total',...
       '\deltaD_G (true T and RH)',...
       '\deltaD_G (true T, fixed RH)',...
       '\deltaD_G (nominal T, fixed RH)');
legend boxoff
set(lh_tgrad,'units','centimeters','position',l_tgrad_pos)
end
xlabel(['Nominal SST change from ' ctrlnames{jj} ' control (K)'],'fontsize',...
    fontsize)
text(panel_xval,panel_yval,panel_labs{2,jj},'fontsize',fontsize)
end %AQUA + SH JJA

% c) Draw total transport-based diffusivity decomposition
for jj = 1:2
    %AQUA + SH JJA

axarr(2,jj) = axes('units','centimeters','position',axpos_dsele{jj});

for ii = 1:size(dsele_style,1)
    %terms--for legend
plot(axarr(2,jj),-10,0,'marker','o','color',dsele_style{ii,1},...
    'markerfacecolor',dsele_style{ii,2},'linestyle',dsele_style{ii,3},...
    'markersize',4,'linewidth',1);
hold on
end %terms--for legend
patch([-10 10 10 -10],all_mlv(1,jj)*[-1 -1 1 1],[.9 .9 .9],...
    'linestyle','none')
plot([-9 9],[0 0],'k-','linewidth',0.5)

for ii = 1:size(dsele_style,1)
    %terms--actual data
plot(d_sst,dmax_dl(ii,:,jj),'marker','o','color',dsele_style{ii,1},...
    'markerfacecolor',dsele_style{ii,2},'linestyle',dsele_style{ii,3},...
    'linewidth',1,'markersize',4);
end %terms--actual data

set(axarr(2,jj),'position',axpos_dsele{jj},'xlim',[-9 9],'xtick',d_sst,...
    'fontsize',fontsize,'ylim',ylims,'ytick',yticks,'xticklabel',[],...
    'layer','top')
if jj==1
ylabel('Shift of D maximum (deg poleward)','fontsize',fontsize)
elseif jj==2
set(axarr(2,jj),'yticklabels',[]) %No y labels on right column
end
if jj==2 %(kk==1) && (jj==2)
    %Add the legend to the SH JUL panel
lh_dsele = legend('\deltaD_{}',...
       '\deltaD_G',...
       '\deltaD_{Gl}',...
       '\deltaD_{Gd}',...
       'Gradient residual');
legend boxoff
set(lh_dsele,'units','centimeters','position',l_dsele_pos)
end
text(panel_xval,panel_yval,panel_labs{1,jj},'fontsize',fontsize)
end %AQUA + SH JJA

% d) Save figure
pause(1)
set(fh,'position',[3 3 fwidth fheight])
pause(1)
set(axarr(1,1),'position',axpos_tgrad{1})
pause(1)
set(axarr(1,2),'position',axpos_tgrad{2})
pause(1)
set(axarr(2,1),'position',axpos_dsele{1})
pause(1)
set(axarr(2,2),'position',axpos_dsele{2})
pause(1)
set(gcf,'position',[3 3 fwidth fheight])
pause(1)
print(fh,'-dpsc','Tgrad_DSELE_SH_JJA_archive.ps'); 
pause(1)
close(fh)
