% basic_mmc_SH_all_archive

% 1) LOAD PRIMARY DATA
ws_dir = '';
amip_ws = load([ws_dir 'tiffany_AMIP16K_Dmax_attrib_jul31_2019.mat']);
dmax_lv = amip_ws.dmax_lats_vals;  %11 terms x 9 exps x (shift + change) x 4 seasons
d_sst   = amip_ws.d_sst;
SC_id   = amip_ws.SC_id;
seaslist= amip_ws.seaslist; %JJA, SON, DJF, MAM
%In previous similar plots, residual has been the thing added to
%the individual terms to get the total linear estimate.  Now it will also
%include the thing that needs to be added to the total linear estimate to
%get the actual total change.
dmax_lv(7,:,:,:) = dmax_lv(7,:,:,:)-diff(dmax_lv(1:2,:,:,:),1,1);
dmax_lv = dmax_lv([1 3:9 11],:,:,:); %Reduce to actual, total transport,
    %MMC transport, QSW transport, gradient, resid_new, MMC dyn, MMC thrm,
    %MMC resid--yes, the actual shifts and changes decompose as expected to
    %within 8.4 parts in 10^13.
    
% 2) LOAD INTERNAL VARIABILITY DATA
amip_iav = load([ws_dir 'tiffany_AMIP16K_Dmax_attrib_aug06_2019.mat']);
amip_mlv = amip_iav.max_lats_vals;%30 years x 4 seasons x lats,vals
amip_mlv(:,:,2) = amip_mlv(:,:,2)/1e9; %Switch max units to 10^9 kg/s
amip_mlv = squeeze(std(amip_mlv,1,1)); %Standard deviation across years,
    %normalize by N because data are complete--4 seasons x lats,vals

% 3) SET FIGURE PARAMETERS
% a) Horizontal half page w/ legends at right, 19.0 cm wide x 11.5 cm tall
fwidth   = 19; %Figure width
fheight  = 11.5; %Figure height
bmargin  = .9; %Bottom margin
hmargin  = .3; %Horizontal margin (between rows)
tmargin  = .25; %Top margin
lmargin  = 1.2; %Left margin
vmargin  = .3; %Vertical margin (between columns)
rmargin  = .25;%Right margin
pheight  = 0.5*(fheight-bmargin-hmargin-tmargin); %Panel height
pwidth   = 0.5*(fwidth-lmargin-vmargin-rmargin);%Panel width

% 4) SET AXES PARAMETERS
fontsize = 8; %Requested by AGU
basic_style = {cblind8('ver'),cblind8('ver'),'-';...  %Actual
               cblind8('rpu'),cblind8('rpu'),'-';...  %Total transport
               cblind8('bgr'),cblind8('bgr'),'-';...  %MMC transport
               cblind8('blu'),cblind8('blu'),'-';...  %SE transport
               cblind8('ora'),cblind8('ora'),'-';...  %Gradient
               cblind8('bla'),cblind8('bla'),'-'};...  %Interaction term
    %Styles for new basic decomposition lines--first column is color, second
    %column is marker face color, third column is line style.  This is the
    %order in which the terms are stored in the dmax_lats_values arrays
    %(rows 1-5)
basic_ylims  = {[-10 10],[-4 6]}; %shift + change
basic_yticks = {-10:2:10,-4:6};
mmc_style   = {cblind8('ver'),cblind8('ver'),'-';...  %Actual
               [],[],[];...
               cblind8('bgr'),cblind8('bgr'),'-';...  %MMC transport
               [],[],[];...
               [],[],[];...
               [],[],[];...
               cblind8('sbl'),cblind8('sbl'),'-';...  %Change flow @ fixed MSE
               cblind8('sbl'),'none'        ,'--';... %Change MSE @ fixed flow
               cblind8('bla'),'none'        ,':'};   %Interaction of MMC terms
mmc_ylims  = basic_ylims; %Want axes to vary ONLY with shift/change
mmc_yticks = basic_yticks;
panel_labs = {'(a)','(b)';'(c)','(d)'}; %One per panel
panel_yval = [8 4.75]; %shift + change
panel_xval = -8;
               
% 5) CHECK IF FIGURES EXIST
%sname = mfilename;
%sname = sname(18:end); %Get version number
%plot_dir = '/project/tas1/tmooring/plots/echam_diffusivity_plots/';
%for jj = 1:numel(seaslist) %JJA, SON, DJF, MAM
%for ii = 1:numel(SC_id) %shift,change
%    if exist([plot_dir 'basic_mmc_SH_all_' seaslist{jj} '_' SC_id{ii} ...
%            '_' sname '.ps'],'file')
%        error('Planned output plot already exists!')
%    end
%end
%end

% 6) DRAW THE FIGURES
axpos_basic = {[lmargin     bmargin+pheight+hmargin pwidth pheight],...
    [lmargin+pwidth+vmargin bmargin+pheight+hmargin pwidth pheight]};
axpos_mmc   = {[lmargin     bmargin                 pwidth pheight],...
    [lmargin+pwidth+vmargin bmargin                 pwidth pheight]};
yldesc      = {'Shift of','Change in'};
ylunits     = {'(deg poleward)','(Tg/s)'}; %1 Tg = 10^9 kg
l_basic_pos = {[14 6.3 3 2],[5.25 9    3 2]}; %shift + change
l_mmc_pos   = {[14 1   3 2],[5.25 3.25 3 2]};
use_seas = [3 1; 4 2]; %Season indices to use in each figure.  Each row is
    %a different figure, each column is a figure column.  Thus JJA will go
    %in the right column of the first shift and change figures, while MAM
    %will go in the left column of the second shift and change figures.
for ll = 1:2 %season pair 1 + season pair 2
for kk = 1:2 %shift + change
    
% a) Create figure
fh = figure('units','centimeters','position',[3 3 fwidth fheight],...
    'paperunits','centimeters','papersize',[fwidth fheight],...
    'paperposition',[0 0 fwidth fheight],'color','w');
axarr = NaN(2,2); %Axes IDs for current figure

% b) Draw basic decomposition
for jj = 1:2 %season 1 + season 2

axarr(1,jj) = axes('units','centimeters','position',axpos_basic{jj});

for ii = 1:size(basic_style,1) %terms--for legend
plot(axarr(1,jj),-10,0,'marker','o','color',basic_style{ii,1},...
    'markerfacecolor',basic_style{ii,2},'linestyle',basic_style{ii,3},...
    'markersize',4,'linewidth',1);
hold on
end %terms--for legend
patch([-10 10 10 -10],amip_mlv(use_seas(ll,jj),kk)*[-1 -1 1 1],...
    [.9 .9 .9],'linestyle','none') %amip_mlv has dims 4 seasons x lats,vals
plot([-9 9],[0 0],'k-','linewidth',0.5)

for ii = 1:size(basic_style,1) %terms--actual data
plot(d_sst,dmax_lv(ii,:,kk,use_seas(ll,jj)),'marker','o','color',...
    basic_style{ii,1},'markerfacecolor',basic_style{ii,2},'linestyle',...
    basic_style{ii,3},'linewidth',1,'markersize',4); %dmax_lv has dims
    %9 terms x 9 exps x (shift + change) x 4 seasons
end %terms--actual data

set(axarr(1,jj),'position',axpos_basic{jj},'xlim',[-9 9],'xtick',d_sst,...
    'fontsize',fontsize,'ylim',basic_ylims{kk},'ytick',basic_yticks{kk},...
    'xticklabel',[],'layer','top')
if jj==1

    ylabel([yldesc{kk} ' D maximum ' ylunits{kk}],'fontsize',fontsize)
elseif jj==2
set(axarr(1,jj),'yticklabels',[]) %No y labels on right column
end %jj
if jj==2 %Add the basic legend to the upper row of panels
lh_basic = legend('\deltaD_{}',...
       '\deltaD_{Htot}',...
       '\deltaD_{Hmmc}',...
       '\deltaD_{Hse}',...
       '\deltaD_G',...
       'Residual');
legend boxoff
set(lh_basic,'units','centimeters','position',l_basic_pos{kk})
end %jj==2
text(panel_xval,panel_yval(kk),[panel_labs{1,jj} ' ' ...
    seaslist{use_seas(ll,jj)}],'fontsize',fontsize)
end %season 1 + season 2

% c) Draw MMC decomposition
for jj = 1:2 %season 1 + season 2

axarr(2,jj) = axes('units','centimeters','position',axpos_mmc{jj});

for ii = [1 3 7:9] %terms--for legend
plot(axarr(2,jj),-10,0,'marker','o','color',mmc_style{ii,1},...
    'markerfacecolor',mmc_style{ii,2},'linestyle',mmc_style{ii,3},...
    'markersize',4,'linewidth',1);
hold on
end %terms--for legend
patch([-10 10 10 -10],amip_mlv(use_seas(ll,jj),kk)*[-1 -1 1 1],...
    [.9 .9 .9],'linestyle','none')
plot([-9 9],[0 0],'k-','linewidth',0.5)

for ii = [1 3 7:9] %terms--actual data
plot(d_sst,dmax_lv(ii,:,kk,use_seas(ll,jj)),'marker','o','color',...
    mmc_style{ii,1},'markerfacecolor',mmc_style{ii,2},'linestyle',...
    mmc_style{ii,3},'linewidth',1,'markersize',4);
end %terms--actual data

set(axarr(2,jj),'position',axpos_mmc{jj},'xlim',[-9 9],'xtick',d_sst,...
    'fontsize',fontsize,'ylim',mmc_ylims{kk},'ytick',mmc_yticks{kk},...
    'layer','top')
if jj==1
ylabel([yldesc{kk} ' D maximum ' ylunits{kk}],'fontsize',fontsize)
elseif jj==2
set(axarr(2,jj),'yticklabels',[]) %No y labels on right column
end %jj
if jj==2 %Add the MMC legend to the lower row of panels
lh_mmc = legend('\deltaD_{}',...
       '\deltaD_{Hmmc}',...
       '\deltaD_{Hmmc,dyn}',...
       '\deltaD_{Hmmc,thr}',...
       'MMC residual');
legend boxoff
set(lh_mmc,'units','centimeters','position',l_mmc_pos{kk})
end %jj==2
xlabel('Nominal SST change from AMIP control (K)','fontsize',fontsize)
text(panel_xval,panel_yval(kk),[panel_labs{2,jj} ' ' ...
    seaslist{use_seas(ll,jj)}],'fontsize',fontsize)

end %season 1 + season 2

% d) Save figure
pause(1)
set(fh,'position',[3 3 fwidth fheight])
pause(1)
set(axarr(1,1),'position',axpos_basic{1})
pause(1)
set(axarr(1,2),'position',axpos_basic{2})
pause(1)
set(axarr(2,1),'position',axpos_mmc{1})
pause(1)
set(axarr(2,2),'position',axpos_mmc{2})
pause(1)
set(gcf,'position',[3 3 fwidth fheight])
pause(1)
print(fh,'-dpsc',['basic_mmc_SH_' seaslist{use_seas(ll,1)} '_' ...
    seaslist{use_seas(ll,2)} '_' SC_id{kk} '_archive.ps']); %On draft
    %copies of these SH multiseason shift and change attribution figures
    %PageBoundingBox has value 0 0 539 326. This corresponds to a figure
    %19.0147 cm wide and 11.5006 cm high, as desired.
pause(1)
close(fh)

end %shift + change
end %season pair 1 + season pair 2
