% basic_mmc_SH_JJA_archive

% 1) LOAD PRIMARY DATA
ws_dir = '';
aqua_ws = load([ws_dir 'tiffany_ECHAM16K_Dmax_attrib_jul10_2018.mat']);
amip_ws = load([ws_dir 'tiffany_AMIP16K_Dmax_attrib_jul09_2018.mat']);
slaq_ws = load([ws_dir 'tiffany_aquaslab_1x4xCO2_Dmax_attrib_jun13_2019.mat']);
slre_ws = load([ws_dir 'tiffany_realslab_1x4xCO2_Dmax_attrib_jun13_2019.mat']);
dmax_lv_aqua = aqua_ws.dmax_lats_vals; %11 terms x 9 exps x (shift + change)
    %Shifts are [-5.66 8.66], changes are [-3.14 3.87]
dmax_lv_amip = amip_ws.dmax_lats_vals;  %11 terms x 9 exps x (shift + change)
    %Shifts are [-2.75 4.99], changes are [-3.51 2.03]
dmax_lv_slaq = slaq_ws.dmax_lats_vals; %11 terms x 2 exps x (shift + change)
dmax_lv_slre = slre_ws.dmax_lats_vals; %11 terms x 2 exps x (shift + change)
dmax_lv      = cat(4,dmax_lv_aqua,dmax_lv_amip); %11 terms x 9 exps x (shift + change) x (AQUA + AMIP)
dmax_lv_sl   = cat(4,dmax_lv_slaq,dmax_lv_slre); %11 terms x 2 exps x (shift + change) x (SLAQ + SLRE)
d_sst        = amip_ws.d_sst;
d_sst_sl     = [3.9201965 6.1168213]; %AQ, RE
    %tsurf changes for AQ and RE are ~3.9 & ~6.1K, taken from 
    %ECHAM6_temperature_averages_apr15_2019_log--may need to pick other
    %values for plot legibility
SC_id   = aqua_ws.SC_id;
%In previous versions of this plot, residual has been the thing added to
%the individual terms to get the total linear estimate.  Now it will also
%include the thing that needs to be added to the total linear estimate to
%get the actual total change.
dmax_lv(   7,:,:,:)  = dmax_lv(   7,:,:,:)-diff(dmax_lv(   1:2,:,:,:),1,1);
dmax_lv_sl(7,:,:,:)  = dmax_lv_sl(7,:,:,:)-diff(dmax_lv_sl(1:2,:,:,:),1,1);
%We will also combine the MMC nonlinear and residual terms:
%dmax_lv(11,:,:,:) = sum(dmax_lv(10:11,:,:,:),1);
dmax_lv    = dmax_lv(   [1 3:9 11],:,:,:);
dmax_lv_sl = dmax_lv_sl([1 3:9 11],:,:,:);%Reduce to actual, total transport,
    %MMC transport, QSW transport, gradient, resid_new, MMC dyn, MMC thrm, MMC resid

% 2) LOAD INTERNAL VARIABILITY DATA
aqua_iav = load([ws_dir 'tiffany_ECHAM16K_Dmax_attrib_jul12_2018.mat']);
amip_iav = load([ws_dir 'tiffany_AMIP16K_Dmax_attrib_jul12_2018.mat']);

aqua_mlv = squeeze(aqua_iav.max_lats_vals(:,:,1,:));%4 seasons x 9 years
    %x (max lats + max vals).  This is for Qobs with the diffusivity
    %defined using transient eddy transport.
aqua_mlv = reshape(aqua_mlv,[36 2]); %36 seasons x (max lats + max vals)
aqua_mlv(:,2) = aqua_mlv(:,2)/1e9; %Switch max units to 10^9 kg/s
aqua_mlv      = std(aqua_mlv,1,1); %Standard deviation across months,
    %normalize by N because data are complete

amip_mlv = squeeze(amip_iav.max_lats_vals(:,1,:));
    %Select 30 years x transient-eddy based x (max lats + max vals)
amip_mlv(:,2) = amip_mlv(:,2)/1e9; %Switch max units to 10^9 kg/s
amip_mlv      = std(amip_mlv,1,1); %Standard deviation across years,
    %normalize by N because data are complete
    
both_mlv = [aqua_mlv' amip_mlv']; %(shift + change) x (AQUA + SH JUL)

% 3) SET FIGURE PARAMETERS
% a) Horizontal half page w/ legends at right, 19.0 cm wide x 11.5 cm tall
fwidth   = 19; %Figure width
fheight  = 11.5; %Figure height
%legwidth = 0;%6; %Legend width
bmargin  = .9; %Bottom margin
hmargin  = .3; %Horizontal margin (between rows)
tmargin  = .25; %Top margin
lmargin  = 1; %Left margin
vmargin  = .3; %Vertical margin (between columns)
rmargin  = .25;%Right margin
%lgmleft  = .25;%Margin to the left of the legend
%lgmright = .25;%Margin to the right of the legend
pheight  = 0.5*(fheight-bmargin-hmargin-tmargin); %Panel height
%pwidth   = 0.5*(fwidth-lmargin-vmargin-legwidth-lgmleft-lgmright);%P. width
pwidth   = 0.5*(fwidth-lmargin-vmargin-rmargin);%Panel width

% 4) SET AXES PARAMETERS
fontsize = 8; %Requested by AGU
basic_style = {cblind8('ver'),cblind8('ver'),'-';...  %Actual
               cblind8('rpu'),cblind8('rpu'),'-';...  %Total transport
               cblind8('bgr'),cblind8('bgr'),'-';...  %MMC transport
               cblind8('blu'),cblind8('blu'),'-';...  %SE transport
               cblind8('ora'),cblind8('ora'),'-';...  %Gradient
               cblind8('bla'),cblind8('bla'),'-'};...  %Interaction term
    %Styles for new basic decomposition lines--first column is color, second
    %column is marker face color, third column is line style.  This is the
    %order in which the terms are stored in the dmax_lats_values arrays
    %(rows 1-5)
basic_ylims  = {[-6 10],[-6 4]}; %shift + change
basic_yticks = {-6:2:10,-6:4};
mmc_style   = {cblind8('ver'),cblind8('ver'),'-';...  %Actual
               [],[],[];...
               cblind8('bgr'),cblind8('bgr'),'-';...  %MMC transport
               [],[],[];...
               [],[],[];...
               [],[],[];...
               cblind8('sbl'),cblind8('sbl'),'-';...  %Change flow @ fixed MSE
               cblind8('sbl'),'none'        ,'--';... %Change MSE @ fixed flow
               cblind8('bla'),'none'        ,':'};   %Interaction of MMC terms
mmc_ylims  = basic_ylims; %Want axes to vary ONLY with shift/change
mmc_yticks = basic_yticks;
panel_labs = {'(a)','(b)';'(c)','(d)'}; %One per panel
panel_yval = [8 2.75]; %shift + change
panel_xval = -8;
               
% 5) CHECK IF FIGURES EXIST
%sname = mfilename;
%sname = sname(18:end); %Get version number
%plot_dir = '/project/tas1/tmooring/plots/echam_diffusivity_plots/';
%if exist([plot_dir 'basic_mmc_SH_JJA_shift_'  sname '.ps'],'file') || ...
%   exist([plot_dir 'basic_mmc_SH_JJA_change_' sname '.ps'],'file')
%    error('Planned output plot already exists!')
%end

% 6) DRAW THE FIGURES
axpos_basic = {[lmargin     bmargin+pheight+hmargin pwidth pheight],...
    [lmargin+pwidth+vmargin bmargin+pheight+hmargin pwidth pheight]};
axpos_mmc   = {[lmargin     bmargin                 pwidth pheight],...
    [lmargin+pwidth+vmargin bmargin                 pwidth pheight]};
ctrlnames   = {'AQUA','AMIP'};
yldesc      = {'Shift of','Change in'};
ylunits     = {'(deg poleward)','(Tg/s)'}; %1 Tg = 10^9 kg
l_basic_pos = {[12 8.75 3 2],[5.25 6.5  3 2]}; %shift + change
l_mmc_pos   = {[12 3.5  3 2],[5.25 1.25 3 2]};
for kk = 1:2
    %shift + change
    
% a) Create figure
fh = figure('units','centimeters','position',[3 3 fwidth fheight],...
    'paperunits','centimeters','papersize',[fwidth fheight],...
    'paperposition',[0 0 fwidth fheight],'color','w');
axarr = NaN(2,2); %Axes IDs for current figure

% b) Draw basic decomposition
for jj = 1:2
    %AQUA + SH JUL

axarr(1,jj) = axes('units','centimeters','position',axpos_basic{jj});

for ii = 1:size(basic_style,1)
    %terms--for legend
plot(axarr(1,jj),-10,0,'marker','o','color',basic_style{ii,1},...
    'markerfacecolor',basic_style{ii,2},'linestyle',basic_style{ii,3},...
    'markersize',4,'linewidth',1);
hold on
end %terms--for legend
patch([-10 10 10 -10],both_mlv(kk,jj)*[-1 -1 1 1],[.9 .9 .9],...
    'linestyle','none')
plot([-9 9],[0 0],'k-','linewidth',0.5)

for ii = 1:size(basic_style,1)
    %terms--actual data
plot(d_sst,dmax_lv(ii,:,kk,jj),'marker','o','color',basic_style{ii,1},...
    'markerfacecolor',basic_style{ii,2},'linestyle',basic_style{ii,3},...
    'linewidth',1,'markersize',4);
end %terms--actual data

for ii = 1:size(basic_style,1)
    %terms--actual data for slab oceans
plot(d_sst_sl(jj),dmax_lv_sl(ii,2,kk,jj),'marker','^','color',basic_style{ii,1},...
    'markerfacecolor',basic_style{ii,2},'linestyle',basic_style{ii,3},...
    'linewidth',1,'markersize',4);
end %terms--actual data for slab oceans

set(axarr(1,jj),'position',axpos_basic{jj},'xlim',[-9 9],'xtick',d_sst,...
    'fontsize',fontsize,'ylim',basic_ylims{kk},'ytick',basic_yticks{kk},...
    'xticklabel',[],'layer','top')
if jj==1
ylabel([yldesc{kk} ' D maximum ' ylunits{kk}],'fontsize',fontsize)
elseif jj==2
set(axarr(1,jj),'yticklabels',[]) %No y labels on right column
end
if jj==2 %(kk==1) && (jj==2)
    %Add the basic legend to the SH JUL shift panel
lh_basic = legend('\deltaD_{}',...
       '\deltaD_{Htot}',...
       '\deltaD_{Hmmc}',...
       '\deltaD_{Hse}',...
       '\deltaD_G',...
       'Residual');
legend boxoff
set(lh_basic,'units','centimeters','position',l_basic_pos{kk})
end
text(panel_xval,panel_yval(kk),panel_labs{1,jj},'fontsize',fontsize)
end %AQUA + SH JUL

% c) Draw MMC decomposition
for jj = 1:2
    %AQUA + SH JUL

axarr(2,jj) = axes('units','centimeters','position',axpos_mmc{jj});

for ii = [1 3 7:9] %[1 3 6:8] %[1 2 4 8:11] %1:size(mmc_style,1)
    %terms--for legend
plot(axarr(2,jj),-10,0,'marker','o','color',mmc_style{ii,1},...
    'markerfacecolor',mmc_style{ii,2},'linestyle',mmc_style{ii,3},...
    'markersize',4,'linewidth',1);
hold on
end %terms--for legend
patch([-10 10 10 -10],both_mlv(kk,jj)*[-1 -1 1 1],[.9 .9 .9],...
    'linestyle','none')
plot([-9 9],[0 0],'k-','linewidth',0.5)

for ii = [1 3 7:9] %[1 3 6:8] %[1 2 4 8:11] %1:size(mmc_style,1)
    %terms--actual data
plot(d_sst,dmax_lv(ii,:,kk,jj),'marker','o','color',mmc_style{ii,1},...
    'markerfacecolor',mmc_style{ii,2},'linestyle',mmc_style{ii,3},...
    'linewidth',1,'markersize',4);
end %terms--actual data

for ii = [1 3 7:9] %[1 3 6:8] %[1 2 4 8:11] %1:size(mmc_style,1)
    %terms--actual data for slab oceans
plot(d_sst_sl(jj),dmax_lv_sl(ii,2,kk,jj),'marker','^','color',mmc_style{ii,1},...
    'markerfacecolor',mmc_style{ii,2},'linestyle',mmc_style{ii,3},...
    'linewidth',1,'markersize',4);
end %terms--actual data for slab oceans

set(axarr(2,jj),'position',axpos_mmc{jj},'xlim',[-9 9],'xtick',d_sst,...
    'fontsize',fontsize,'ylim',mmc_ylims{kk},'ytick',mmc_yticks{kk},...
    'layer','top')
if jj==1
ylabel([yldesc{kk} ' D maximum ' ylunits{kk}],'fontsize',fontsize)
elseif jj==2
set(axarr(2,jj),'yticklabels',[]) %No y labels on right column
end
if jj==2 %(kk==1) && (jj==2)
    %Add the MMC legend to the SH JUL shift panel
lh_mmc = legend('\deltaD_{}',...
       '\deltaD_{Hmmc}',...
       '\deltaD_{Hmmc,dyn}',...
       '\deltaD_{Hmmc,thr}',...
       'MMC residual');
legend boxoff
set(lh_mmc,'units','centimeters','position',l_mmc_pos{kk})
end
xlabel(['Nominal SST change from ' ctrlnames{jj} ' control (K)'],'fontsize',...
    fontsize)
text(panel_xval,panel_yval(kk),panel_labs{2,jj},'fontsize',fontsize)
end %AQUA + SH JUL

% d) Save figure
pause(1)
set(fh,'position',[3 3 fwidth fheight])
pause(1)
set(axarr(1,1),'position',axpos_basic{1})
pause(1)
set(axarr(1,2),'position',axpos_basic{2})
pause(1)
set(axarr(2,1),'position',axpos_mmc{1})
pause(1)
set(axarr(2,2),'position',axpos_mmc{2})
pause(1)
set(gcf,'position',[3 3 fwidth fheight])
pause(1)
print(fh,'-dpsc',['basic_mmc_SH_JJA_' SC_id{kk} '_archive.ps']); %On draft copies of these
    %figures PageBoundingBox has value 0 0 539 326.  This corresponds to a
    %figure 19.0147 cm wide and 11.5006 cm high, as desired.
pause(1)
close(fh)

end %shift + change
