% energy_SHF_SH_JJA_archive

% 1) LOAD PRIMARY DATA
ws_dir = '';
aqua_ws = load([ws_dir 'tiffany_ECHAM16K_Dmax_attrib_jul13_2018.mat']);
amip_ws = load([ws_dir 'tiffany_AMIP16K_Dmax_attrib_jul13_2018.mat']);
    %Energy budget
aqua_ws_al = load([ws_dir 'tiffany_ECHAM16K_Dmax_attrib_jul10_2018.mat']);
amip_ws_al = load([ws_dir 'tiffany_AMIP16K_Dmax_attrib_jul09_2018.mat']);
    %Reference (actual)
dmax_lv_aqua = aqua_ws.dmax_lats_vals(:,:,2); %10 terms x 9 exps
dmax_lv_amip = amip_ws.dmax_lats_vals(:,:,2); %Term orders same for both
dmax_lv = cat(3,dmax_lv_aqua,dmax_lv_amip);%10 terms x 9 exps x (AQUA,AMIP)
dmax_lv = cat(1,cat(3,aqua_ws_al.dmax_lats_vals(1,:,2),...
                      amip_ws_al.dmax_lats_vals(1,:,2)),dmax_lv);
    %Add on actual changes to get 11 terms x 9 exps x (AQUA,AMIP)--list now
    %1  Actual
    %2  Total transport
    %3  SW absorption
    %4  Surface fluxes
    %5  OLR
    %6  Storage/bnd. flx. err.
    %7  Total transport interaction
    %8  Surface LW
    %9  Sensible
    %10 Evaporation
    %11 SFC flux transport interaction
dmax_lv(6,:,:) = sum(dmax_lv(6:7,:,:),1); %Combine storage/bnd. flx. err.
dmax_lv = dmax_lv([1:6 8:11],:,:); %and total transport interaction terms
    %1  Actual
    %2  Total transport
    %3  SW absorption
    %4  Surface fluxes
    %5  OLR
    %6  Storage/bnd. flx. err. + Total transport interaction
    %7  Surface LW
    %8  Sensible
    %9  Evaporation
    %10 SFC flux transport interaction
dmax_lv_p = cell(2,1); %Separate array for each row of plot--each array
    %will have N terms x 9 exps x (AQUA,AMIP)
dmax_lv_p{1} = dmax_lv(1:6,:,:); %Energy budget
    %1  Actual
    %2  Total transport
    %3  SW absorption
    %4  Surface fluxes
    %5  OLR
    %6  Storage/bnd. flx. err. + Total transport interaction
dmax_lv_p{2} = dmax_lv([1 2 4 9 8 7 10],:,:); %SHF
    %1  Actual
    %2  Total transport
    %4  Surface fluxes
    %9  Evaporation
    %8  Sensible
    %7  Surface LW
    %10 SFC flux transport interaction
d_sst = aqua_ws.d_sst;

% 2) LOAD INTERNAL VARIABILITY DATA
%    Taken virtually without modification from energy_Dtotal_SH_JJA_v3
aqua_iav = load([ws_dir 'tiffany_ECHAM16K_Dmax_attrib_jul12_2018.mat']);
amip_iav = load([ws_dir 'tiffany_AMIP16K_Dmax_attrib_jul12_2018.mat']);

aqua_mlv = aqua_iav.max_lats_vals(:,:,:,2); %4 seas x 9 yrs x TE,total
amip_mlv = amip_iav.max_lats_vals(:,:,2); %30 yrs x TE,total

aqua_mlv = reshape(aqua_mlv,[36 2])/1e9; %36 seasons x TE,total--yes, the
    %reshape command is formulated correctly.  Switch units to 10^9 kg/s
aqua_mlv = std(aqua_mlv,1,1); %Standard deviation across years,
    %normalize by N because data are complete, 1 x TE,total

amip_mlv = std(amip_mlv/1e9,1,1); %Units change, std dev across years,
    %1 x TE,total
    
all_mlv = [aqua_mlv; amip_mlv]; %Combine--(AQUA, AMIP) x (TE,total)
all_mlv = all_mlv'; %Transpose to (TE,total) x (AQUA,AMIP) to avoid need
    %for further changes to the script
all_mlv = all_mlv(1,:); %Do not need total transport variability here

% 3) SET FIGURE PARAMETERS
% a) Horizontal half page w/ legends at right, 19.0 cm wide x 11.5 cm tall
fwidth   = 19; %Figure width
fheight  = 11.5; %Figure height
bmargin  = .9; %Bottom margin
hmargin  = .3; %Horizontal margin (between rows)
tmargin  = .25; %Top margin
lmargin  = 1; %Left margin
vmargin  = .3; %Vertical margin (between columns)
rmargin  = .25;%Right margin
pheight  = 0.5*(fheight-bmargin-hmargin-tmargin); %Panel height
pwidth   = 0.5*(fwidth-lmargin-vmargin-rmargin);%Panel width

% 4) SET AXES PARAMETERS
fontsize = 8; %Requested by AGU
basic_style = {{cblind8('ver'),cblind8('ver'),'-';...  %Actual
                cblind8('rpu'),cblind8('rpu'),'-';...  %Total transport
                cblind8('sbl'),cblind8('sbl'),'-';...  %Shortwave
                cblind8('sbl'),cblind8('sbl'),'--';... %Surface fluxes
                cblind8('sbl'),cblind8('sbl'),'-.';... %OLR
                cblind8('bla'),'none'        ,':'};... %Trans. interaction
               {cblind8('ver'),cblind8('ver'),'-';...  %Actual
                cblind8('rpu'),cblind8('rpu'),'-';...  %Total transport
                cblind8('sbl'),cblind8('sbl'),'--';...  %Surface fluxes
                cblind8('bgr'),cblind8('bgr'),'-';...  %Latent
                cblind8('bgr'),cblind8('bgr'),'--';...  %Sensible
                cblind8('bgr'),cblind8('bgr'),'-.';...  %Surface LW
                cblind8('bla'),'none'        ,':'}}; %SFC flux interaction
    %Styles for energy budget decomposition lines--1st column is color, 2nd
    %column is marker face color, third column is line style.  This is the
    %order in which the terms are stored in the dmax_lv_p{ii} arrays
basic_ylims  = [-6 4];
basic_yticks = -6:4;
panel_labs = {'(a)','(b)';'(c)','(d)'}; %One per panel
panel_yval = 2.75;
panel_xval = -8;
               
% 5) CHECK IF FIGURE EXISTS
%sname = mfilename;
%sname = sname(19:end); %Get version number
%plot_dir = '/project/tas1/tmooring/plots/echam_diffusivity_plots/';
%if exist([plot_dir 'energy_SHF_SH_JJA_'  sname '.ps'],'file')
%    error('Planned output plot already exists!')
%end

% 6) DRAW THE FIGURES
axpos_basic = {[lmargin     bmargin+pheight+hmargin pwidth pheight],...
    [lmargin+pwidth+vmargin bmargin+pheight+hmargin pwidth pheight];...
               [lmargin     bmargin                 pwidth pheight],...
    [lmargin+pwidth+vmargin bmargin                 pwidth pheight]};
ctrlnames   = {'AQUA','AMIP'};
l_basic_pos = {[14.25 6.6                  3.25 1.9 ];...
               [14.25 6.75-pheight-hmargin 3.25 1.75]};

% a) Create figure
fh = figure('units','centimeters','position',[3 3 fwidth fheight],...
    'paperunits','centimeters','papersize',[fwidth fheight],...
    'paperposition',[0 0 fwidth fheight],'color','w');
axarr = NaN(2,2); %Axes IDs for current figure

% b) Draw panels
for kk = 1:2 %energy, SHF
for jj = 1:2 %AQUA, AMIP
axarr(kk,jj) = axes('units','centimeters','position',axpos_basic{kk,jj});

for ii = 1:size(basic_style{kk},1)
    %terms--for legend
plot(axarr(kk,jj),-10,0,'marker','o','color',basic_style{kk}{ii,1},...
    'markerfacecolor',basic_style{kk}{ii,2},'linestyle',basic_style{kk}{...
    ii,3},'markersize',4,'linewidth',1);
hold on
end %terms--for legend
patch([-10 10 10 -10],all_mlv(1,jj)*[-1 -1 1 1],[.9 .9 .9],...
    'linestyle','none')
plot([-9 9],[0 0],'k-','linewidth',0.5)

for ii = 1:size(basic_style{kk},1)
    %terms--actual data
plot(d_sst,dmax_lv_p{kk}(ii,:,jj),'marker','o','color',basic_style{kk}{...
    ii,1},'markerfacecolor',basic_style{kk}{ii,2},'linestyle',...
    basic_style{kk}{ii,3},'linewidth',1,'markersize',4);
end %terms--actual data

set(axarr(kk,jj),'position',axpos_basic{kk,jj},'xlim',[-9 9],'xtick',...
    d_sst,'fontsize',fontsize,'ylim',basic_ylims,'ytick',basic_yticks,...
    'layer','top')
if kk==1
set(axarr(kk,jj),'xticklabel',[])
elseif kk==2
xlabel(['Nominal SST change from ' ctrlnames{jj} ' (K)'],'fontsize',...
    fontsize)
end
if jj==1
ylabel('Change in D maximum (Tg/s)','fontsize',fontsize)
elseif jj==2
set(axarr(kk,jj),'yticklabels',[]) %No y labels on right column
end
if jj==2 %(kk==1) && (jj==2)
if kk==1 %Add the energy budget lengend
lh_basic = legend('\deltaD_{}',...
       '\deltaD_{Htot}',...
       '\deltaD_{SWABS}',...
       '\deltaD_{SHF}',...
       '\deltaD_{OLR}',...
       'Atmospheric storage/residual');
else %kk==2, add SHF legend
lh_basic = legend('\deltaD_{}',...
       '\deltaD_{Htot}',...
       '\deltaD_{SHF}',...
       '\deltaD_{LAT}',...
       '\deltaD_{SENS}',...
       '\deltaD_{LWSFC}',...
       'Surface flux residual');%actual, total linear, total
end
legend boxoff
set(lh_basic,'units','centimeters','position',l_basic_pos{kk})
end
text(panel_xval,panel_yval,panel_labs{kk,jj},'fontsize',fontsize)
end %AQUA, AMIP
end %energy, SHF

% c) Save figure
pause(1)
pause(1)
set(fh,'position',[3 3 fwidth fheight])
for kk = 1:2 %energy, SHF
for jj = 1:2 %AQUA, AMIP
pause(1)
pause(1)
set(axarr(kk,jj),'position',axpos_basic{kk,jj})
pause(1)
pause(1)
end %AQUA, AMIP
end %energy, SHF
pause(1)
pause(1)
pause(1)
print(fh,'-dpsc','energy_SHF_SH_JJA_archive.ps'); %Yes, draft version of this
    %figures looks like the relevant panels of energy_Dtotal_SH_JJA_v7 and
    %SHF_SH_JJA_v3
pause(1)
pause(1)
pause(1)
close(fh)